/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.jdk8;

import dev.compactmods.crafting.lib.reactivex.rxjava3.annotations.NonNull;
import dev.compactmods.crafting.lib.reactivex.rxjava3.annotations.Nullable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Maybe;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.MaybeObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Function;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.DisposableHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public final class MaybeFlattenStreamAsObservable<T, R>
extends Observable<R> {
    final Maybe<T> source;
    final Function<? super T, ? extends Stream<? extends R>> mapper;

    public MaybeFlattenStreamAsObservable(Maybe<T> source, Function<? super T, ? extends Stream<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(@NonNull Observer<? super R> s) {
        this.source.subscribe(new FlattenStreamMultiObserver<T, R>(s, this.mapper));
    }

    static final class FlattenStreamMultiObserver<T, R>
    extends BasicIntQueueDisposable<R>
    implements MaybeObserver<T>,
    SingleObserver<T> {
        private static final long serialVersionUID = 7363336003027148283L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends Stream<? extends R>> mapper;
        Disposable upstream;
        volatile Iterator<? extends R> iterator;
        AutoCloseable close;
        boolean once;
        volatile boolean disposed;
        boolean outputFused;

        FlattenStreamMultiObserver(Observer<? super R> downstream, Function<? super T, ? extends Stream<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(@NonNull Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(@NonNull T t) {
            try {
                Stream<R> stream = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Stream");
                Iterator iterator = stream.iterator();
                Stream<R> c = stream;
                if (!iterator.hasNext()) {
                    this.downstream.onComplete();
                    this.close(c);
                    return;
                }
                this.iterator = iterator;
                this.close = stream;
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(ex);
                return;
            }
            this.drain();
        }

        @Override
        public void onError(@NonNull Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
            if (!this.outputFused) {
                this.drain();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        @Nullable
        public R poll() throws Throwable {
            Iterator<R> it = this.iterator;
            if (it != null) {
                if (this.once) {
                    if (!it.hasNext()) {
                        this.clear();
                        return null;
                    }
                } else {
                    this.once = true;
                }
                return it.next();
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            Iterator<R> it = this.iterator;
            if (it != null) {
                if (!this.once) {
                    return false;
                }
                if (it.hasNext()) {
                    return false;
                }
                this.clear();
            }
            return true;
        }

        @Override
        public void clear() {
            this.iterator = null;
            AutoCloseable close = this.close;
            this.close = null;
            this.close(close);
        }

        void close(AutoCloseable c) {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<R> downstream = this.downstream;
            Iterator<R> it = this.iterator;
            while (true) {
                if (this.disposed) {
                    this.clear();
                } else if (this.outputFused) {
                    downstream.onNext(null);
                    downstream.onComplete();
                } else {
                    boolean has;
                    R item;
                    try {
                        item = it.next();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        downstream.onError(ex);
                        this.disposed = true;
                        continue;
                    }
                    if (this.disposed) continue;
                    downstream.onNext(item);
                    if (this.disposed) continue;
                    try {
                        has = it.hasNext();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        downstream.onError(ex);
                        this.disposed = true;
                        continue;
                    }
                    if (this.disposed || has) continue;
                    downstream.onComplete();
                    this.disposed = true;
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

